if (matches(currentUserID,"KTRUJILLO","VELOSIMO"))
{
	showDebug = true; showMessage= true;
}

logDebug("Checking workflow ="+wfTask+" status="+wfStatus);
if(appMatch("Permits/BUILDING/COMMERCIAL/NEW BUILDING")
{
	if(wfTask == "Process Plans" && wfStatus == "Route to EPR"){
 		sendEventToVelosimo("CreateEPRProject", capId);
 	}
	else if(wfTask == "Process Plans" && wfStatus == "Plans Forwarded"){
  	   createPlanReviewSubTasks(capId); 
            sendEventToVelosimo("CreateEPRAssignments", capId); 
  }
	else if(wfTask == "Final Planning Review" && (wfStatus == "E-Plan Resubmittal Required" || wfStatus == "Plans Approved"))
  {
  	sendTaskEventToVelosimo("UpdatedWorkflowTask", capId, wfTask, wfStep, wfStatus);
  }
}


function createPlanReviewSubTasks(recordId)
{
	var wfObj = aa.workflow.getTasks(recordId).getOutput();
	var recordDocs = new Array();
  var allRecordDocs = aa.document.getCapDocumentList(recordId, lookup("EXTERNAL_DOC_REVIEW","VELOSIMO_ACCELA_USER")).getOutput();
	for(zz in allRecordDocs){
		var recDoc = allRecordDocs[zz];
		if(recDoc.getDocStatus() == "Routed to EPR" || recDoc.getDocStatus() == "Routed for Review" ){
			var validDocs = lookup("EPR_DOCUMENT_CATEGORY",recDoc.getDocCategory());
			if(validDocs != undefined)
			{
				recordDocs.push(recDoc);
			}
		}
	}
	var recordDocsList = java.util.Arrays.asList(recordDocs);

	var resTaskItems = [];
	for (i in wfObj)
	{
    taskItem = wfObj[i];
	
		var validTask = lookup("EPR_REVIEW_TASKS",taskItem.getTaskDescription());

   	if(validTask != undefined && taskItem.getActiveFlag() == "Y")
   	{
			logDebug("Task: "+taskItem.getTaskDescription());
	  	logDebug("Active: "+taskItem.getActiveFlag());

			for(j=0; j<recordDocsList.size(); j++)
			{
				rDoc = recordDocsList.get(j);
				logDebug("Checking if task as subtasks for this doc");
				logDebug("Name: "+rDoc.getFileName());
				logDebug("Doc: "+rDoc.getDocumentNo());
				logDebug("Related Doc: "+rDoc.getRelatedID());	

			  var v1Doc = rDoc;
				var relatedId = rDoc.getRelatedID();
				var relatedDoc = rDoc;

				while(relatedId != null)
				{
					var lastDoc = aa.document.getOriginalDoc(relatedDoc).getOutput()
					if(lastDoc == null)
					{
						break;	
					}
					v1Doc = lastDoc;
					relatedDoc = lastDoc;
					relatedId = lastDoc.getRelatedID();
				}
				logDebug("V1 Doc: "+v1Doc);

				var hasReviewers = aa.document.getRelatedReviewers(v1Doc.getDocumentNo(), taskItem.getTaskItem()).getOutput();
				if(hasReviewers.size() == 0)
				{
					logDebug("No subtasks found. Adding subtasks");
				
    			var usersList = new java.util.ArrayList();
    			usersList.add(taskItem.getAssignedStaff());

					var rDocs = new Array();
					rDocs.push(v1Doc);
    			var reviewTasks = aa.document.associateReviewer2Doc(rDocs, usersList, taskItem.getTaskItem());   
    
			    if(reviewTasks.getSuccess())
 				  { 
     		   	logDebug("Successfully added plan review tasks output="+reviewTasks.getOutput());
					 	rDoc.setDocStatus("Routed for Review");
						aa.document.updateDocument(rDoc);
   				}
   				else
   				{
      			logDebug("Error adding plan review tasks errmsg="+reviewTasks.getErrorMessage()+" output="+reviewTasks.getOutput());
   				}
				}
				else
				{
					logDebug("Task already has subtasks");
				}
				logDebug("");
			}							
 		}
	}
}

function loadCustomScript(scriptName) {

    try {
        scriptName = scriptName.toUpperCase();
        var emseBiz = aa.proxyInvoker.newInstance(
                "com.accela.aa.emse.emse.EMSEBusiness").getOutput();
        var emseScript = emseBiz.getScriptByPK(aa.getServiceProviderCode(),
                scriptName, "ADMIN");
        eval(emseScript.getScriptText() + "");

    } catch (error) {
        showDebug = true;
        logDebug("<font color='red'><b>WARNING: Could not load script </b></font>" + scriptName + ". Verify the script in <font color='blue'>Classic Admin>Admin Tools>Events>Scripts</font>");
        logDebug(error);
}
}


/** This should be in ACCELA_GLOBAL_FUNCTIONS already **
function lookup(stdChoice,stdValue) 
{
	var strControl;
	var bizDomScriptResult = aa.bizDomain.getBizDomainByValue(stdChoice,stdValue);
	
   	if (bizDomScriptResult.getSuccess())
   		{
		var bizDomScriptObj = bizDomScriptResult.getOutput();
		strControl = "" + bizDomScriptObj.getDescription(); // had to do this or it bombs.  who knows why?
		logDebug("lookup(" + stdChoice + "," + stdValue + ") = " + strControl);
		}
	else
		{
		logDebug("lookup(" + stdChoice + "," + stdValue + ") does not exist");
		}
	return strControl;
}

function logDebug(dstr) {
     aa.print(dstr);
     aa.debug(aa.getServiceProviderCode() + " : " + aa.env.getValue("CurrentUserID"), dstr);
}
*/
